﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LifeScript : MonoBehaviour {

    private float lifeSpeed = 15f;

    private Vector2 lifeDirection;

    bool isReady;

	void Start () {
        isReady = false;
	}
	
	void Update () {
        if (isReady) {
            Vector2 position = transform.position;
            position += lifeDirection * lifeSpeed * Time.deltaTime;
            transform.position = position;
        }
    }

    public void SetLifeDirection(Vector2 direction) {
        lifeDirection = direction.normalized;
        isReady = true;
    }
}
